/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import common.constant.SysConst;
import common.util.CsvItem;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class CsvUtil {
    private static final String COMMENT_MARK = "#";

    public static List<ArrayList> readCsv(String fpath, String encode) throws IOException {
        return CsvUtil.readCsv(fpath, encode, ",", false);
    }

    public static List<ArrayList> readCsv(String fpath, String encode, String sepa, boolean dquoteFlg) throws IOException {
        ArrayList<ArrayList> rsltList = new ArrayList<ArrayList>();
        FileInputStream fis = new FileInputStream(fpath);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, encode);
        BufferedReader br = new BufferedReader(isr);
        String line = "";
        while ((line = br.readLine()) != null) {
            int len = (line = line.trim()).length();
            if (len < 1) continue;
            String[] value = line.split(sepa, -1);
            ArrayList<String> columnList = new ArrayList<String>();
            int i = 0;
            while (i < value.length) {
                String buff = value[i];
                if (buff.length() > 0 && dquoteFlg && buff.substring(0, 1).equals("\"") && buff.substring(buff.length() - 1, buff.length()).equals("\"")) {
                    buff = buff.substring(1, buff.length() - 1);
                }
                columnList.add(buff);
                ++i;
            }
            rsltList.add(columnList);
        }
        br.close();
        isr.close();
        fis.close();
        return rsltList;
    }

    public static List<ArrayList> readCsv(String fpath, String encode, String sepa, boolean dquoteFlg, boolean commentFlg) throws IOException {
        ArrayList<ArrayList> rsltList = new ArrayList<ArrayList>();
        FileInputStream fis = new FileInputStream(fpath);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, encode);
        BufferedReader br = new BufferedReader(isr);
        String line = "";
        while ((line = br.readLine()) != null) {
            int len = (line = line.trim()).length();
            if (len < 1 || commentFlg && line.startsWith(COMMENT_MARK)) continue;
            String[] value = line.split(sepa, -1);
            ArrayList<String> columnList = new ArrayList<String>();
            int i = 0;
            while (i < value.length) {
                String buff = value[i];
                if (buff.length() > 0 && dquoteFlg && buff.substring(0, 1).equals("\"") && buff.substring(buff.length() - 1, buff.length()).equals("\"")) {
                    buff = buff.substring(1, buff.length() - 1);
                }
                columnList.add(buff);
                ++i;
            }
            rsltList.add(columnList);
        }
        br.close();
        isr.close();
        fis.close();
        return rsltList;
    }

    public static List<Object> readCsvToObj(String dtoname, String fpath, String encode, String sepa, boolean dquoteFlg, boolean commentFlg) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        ArrayList<Object> rsltList = new ArrayList<Object>();
        FileInputStream fis = new FileInputStream(fpath);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, encode);
        BufferedReader br = new BufferedReader(isr);
        String[] colnames = null;
        int lineNo = 0;
        String line = "";
        while ((line = br.readLine()) != null) {
            int len = (line = line.trim()).length();
            if (len < 1) continue;
            String top = line.substring(0, 1);
            if (commentFlg && top.equals(COMMENT_MARK) || ++lineNo == 1) continue;
            if (lineNo == 2) {
                colnames = line.split(sepa, -1);
                CsvUtil.bothDeleteDQ(colnames);
                continue;
            }
            String[] values = line.split(sepa, -1);
            CsvUtil.bothDeleteDQ(values);
            Class<?> clazz = Class.forName(dtoname);
            Object dtoobj = clazz.newInstance();
            int i = 0;
            while (i < values.length) {
                String value = values[i];
                String colName = colnames[i];
                CsvUtil.setValue(dtoobj, colName, value);
                ++i;
            }
            rsltList.add(dtoobj);
        }
        br.close();
        isr.close();
        fis.close();
        return rsltList;
    }

    static void bothDeleteDQ(String[] titles) {
        int i = 0;
        while (i < titles.length) {
            String value = titles[i];
            if (titles[i].length() >= 2) {
                String left = titles[i].substring(0, 1);
                String right = titles[i].substring(titles[i].length() - 1, titles[i].length());
                if (left.equals("\"") && right.equals("\"")) {
                    value = titles[i].substring(1, titles[i].length() - 1);
                }
            }
            titles[i] = value;
            ++i;
        }
    }

    static void setValue(Object dto, String colname, Object value) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String methodName = "set" + colname.substring(0, 1).toUpperCase() + colname.substring(1, colname.length());
        Object objs = null;
        Method method = dto.getClass().getMethod(methodName, String.class);
        method.invoke(dto, value);
    }

    public static String editCsvLine(ArrayList<CsvItem> itemList, String sepa, boolean dquoteFlg) {
        StringBuilder lineSbf = new StringBuilder();
        int i = 0;
        while (i < itemList.size()) {
            CsvItem item = itemList.get(i);
            switch (item.getDataType()) {
                case 3: {
                    if (!dquoteFlg) break;
                    item.setValue("\"" + item.getValue() + "\"");
                    break;
                }
                case 2: {
                    if (item.getDateValue() != null && item.getDateFormat() != null) {
                        SimpleDateFormat sdf = new SimpleDateFormat(item.getDateFormat());
                        item.setValue(sdf.format(item.getDateValue()));
                        break;
                    }
                    throw new IllegalArgumentException("\u65e5\u4ed8\u30c7\u30fc\u30bf\u4e0d\u6b63");
                }
            }
            lineSbf.append(item.getValue());
            if (i < itemList.size() - 1) {
                lineSbf.append(sepa);
            }
            ++i;
        }
        lineSbf.append(SysConst.CRLF);
        return lineSbf.toString();
    }
}

