/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import common.exception.OtherAppException;
import common.util.ClassNameConvertor;
import common.util.CsvUtil;
import common.util.LogTrace;
import common.util.StringUtilExt;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CsvUtilXXX {
    private final int headlines = 3;
    private final String TITLE_CLASS_NAME = "\u30af\u30e9\u30b9\u540d";
    private final String TITLE_PHYSICAL_ITEM_NAME = "\u7269\u7406\u9805\u76ee\u540d";
    private final String TITLE_DATATYPE_NAME = "\u30c7\u30fc\u30bf\u578b\u540d";
    private final String TITLE_DATA_SECTION = "\u30c7\u30fc\u30bf\u90e8";
    private String logmsg = "";
    private String entClassName = "";
    private ArrayList<String> colnameList = null;
    private ArrayList<String> typenameList = null;

    public void loadCsvData(String csvpath, List<Object> classNameList, List<Object> valueList) throws OtherAppException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException {
        LogTrace.logout(3, "[CsvUtil::loadCsvData] start");
        LogTrace.logout(3, "[CsvUtil::loadCsvData] csvpath = " + csvpath);
        List<Object> rsltList = new ArrayList();
        try {
            rsltList = CsvUtil.readCsv(csvpath, "UTF-8", ",", true);
        }
        catch (IOException e) {
            e.printStackTrace();
            LogTrace.logout(3, "CSV\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        if (rsltList.size() == 0) {
            LogTrace.logout(3, "CSV\u30d5\u30a1\u30a4\u30eb\u30c7\u30fc\u30bf\u304c\uff10\u4ef6\u3067\u3059");
            throw new OtherAppException("CSV\u30d5\u30a1\u30a4\u30eb\u304c\u7a7a\u3067\u3059");
        }
        if (rsltList.size() < 4) {
            this.logmsg = "\u30d8\u30c3\u30c0\u90e8\u306f" + StringUtilExt.hanNumToZen(new Integer(3).toString()) + "\u884c\u4ee5\u4e0a\u306a\u306e\u3067\u5fc5\u305a";
            this.logmsg = String.valueOf(this.logmsg) + StringUtilExt.hanNumToZen(new Integer(4).toString()) + "\u884c\u4ee5\u4e0a\u5fc5\u8981\u3067\u3059\u3002";
            LogTrace.logout(3, this.logmsg);
            throw new OtherAppException(this.logmsg);
        }
        Iterator<Object> itr = rsltList.iterator();
        int dataStart = 0;
        int i = 0;
        while (i < rsltList.size()) {
            ArrayList headlist = (ArrayList)rsltList.get(i);
            String headTypeName = ((String)headlist.get(0)).trim();
            if (headTypeName.compareTo("\u30af\u30e9\u30b9\u540d") == 0) {
                this.entClassName = ((String)headlist.get(1)).trim();
                classNameList.add(this.entClassName);
            } else if (headTypeName.compareTo("\u7269\u7406\u9805\u76ee\u540d") == 0) {
                this.colnameList = (ArrayList)rsltList.get(i);
            } else if (headTypeName.compareTo("\u30c7\u30fc\u30bf\u578b\u540d") == 0) {
                this.typenameList = (ArrayList)rsltList.get(i);
            } else if (headTypeName.compareTo("\u30c7\u30fc\u30bf\u90e8") == 0) {
                dataStart = i + 1;
                break;
            }
            ++i;
        }
        String msgitem = "";
        if (this.entClassName.length() == 0) {
            msgitem = "\u30af\u30e9\u30b9\u540d";
        }
        if (this.colnameList == null) {
            msgitem = "\u7269\u7406\u9805\u76ee\u540d";
        }
        if (this.typenameList == null) {
            msgitem = "\u30c7\u30fc\u30bf\u578b\u540d";
        }
        if (dataStart == 0) {
            msgitem = "\u30c7\u30fc\u30bf\u90e8";
        }
        if (msgitem.length() > 0) {
            throw new OtherAppException(String.valueOf(msgitem) + "\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002\u30d8\u30c3\u30c0\u90e8\u306b\u306f\u3001\u30af\u30e9\u30b9\u540d\u30fb\u7269\u7406\u9805\u76ee\u540d\u30fb\u30c7\u30fc\u30bf\u578b\u540d\u304c\u5fc5\u8981\u3067\u3059\u3002");
        }
        int i2 = dataStart;
        while (i2 < rsltList.size()) {
            ArrayList columnList = (ArrayList)rsltList.get(i2);
            String firstItem = (String)columnList.get(0);
            if (firstItem.substring(0, 1).compareTo("#") != 0) {
                Object entityObj = null;
                try {
                    entityObj = this.outpuData(columnList);
                }
                catch (OtherAppException ex) {
                    throw new OtherAppException("CSV\u30d5\u30a1\u30a4\u30eb\u306e" + new Integer(i2 + 1).toString() + "\u884c\u76ee\uff1a" + ex.getMessage());
                }
                valueList.add(entityObj);
            }
            ++i2;
        }
        LogTrace.logout(3, "[CsvUtil::loadCsvData]testReadCsv end");
    }

    private Object outpuData(ArrayList columnList) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException, OtherAppException {
        Object[] dataArray = columnList.toArray();
        Class<?> entityCls = null;
        entityCls = Class.forName(this.entClassName);
        Object entityObj = entityCls.newInstance();
        int i = 0;
        while (i < dataArray.length) {
            String typeKeyName = this.typenameList.get(i + 1);
            String typeClassName = ClassNameConvertor.db2ToJava(typeKeyName.trim());
            String data = ((String)dataArray[i]).trim();
            if (data.substring(0, 1).compareTo("\"") == 0 && data.substring(data.length() - 1, data.length()).compareTo("\"") != 0 || data.substring(0, 1).compareTo("\"") != 0 && data.substring(data.length() - 1, data.length()).compareTo("\"") == 0) {
                throw new OtherAppException("\u30c0\u30d6\u30eb\u30af\u30a9\u30c6\u30fc\u30b7\u30e7\u30f3\u306e\u5bfe\u5fdc\u304c\u4e0d\u6b63\u3002");
            }
            if (data.substring(0, 1).compareTo("\"") == 0 && data.substring(data.length() - 1, data.length()).compareTo("\"") == 0) {
                data = data.substring(1, data.length() - 1);
            }
            String colname = this.colnameList.get(i + 1);
            colname = colname.trim();
            String setterName = "set" + colname.substring(0, 1).toUpperCase() + colname.substring(1);
            Class<?> typecls = Class.forName(typeClassName);
            Method method = entityCls.getMethod(setterName, typecls);
            this.invoke(entityObj, method, typeClassName, data);
            ++i;
        }
        return entityObj;
    }

    private void invoke(Object entityObj, Method method, String typeClassName, String data) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (typeClassName.compareTo("java.lang.String") == 0) {
            method.invoke(entityObj, data);
        } else if (typeClassName.compareTo("java.lang.Integer") == 0) {
            method.invoke(entityObj, new Integer(data));
        } else if (typeClassName.compareTo("java.sql.Timestamp") == 0) {
            method.invoke(entityObj, Timestamp.valueOf(data));
        } else if (typeClassName.compareTo("java.sql.Date") == 0) {
            method.invoke(entityObj, Date.valueOf(data));
        } else if (typeClassName.compareTo("java.math.BigDecimal") == 0) {
            method.invoke(entityObj, new BigDecimal(data));
        }
    }
}

