/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import common.util.CsvUtil;
import common.util.DataInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FileUtil {
    public static void saveBinary(String fpath, ArrayList<DataInfo> dataList, boolean append) throws IOException, IllegalArgumentException {
        if (dataList.isEmpty()) {
            throw new IllegalArgumentException("dataList is empty.");
        }
        DataOutputStream out = new DataOutputStream(new FileOutputStream(fpath, append));
        for (DataInfo info : dataList) {
            switch (info.dataType) {
                case 1: {
                    FileUtil.writeString(out, info.stringData);
                    break;
                }
                case 2: {
                    FileUtil.writeByteArray(out, info.bytes);
                    break;
                }
                case 3: {
                    out.writeShort(info.shortData);
                    break;
                }
                case 4: {
                    out.writeInt(info.intData);
                    break;
                }
                case 5: {
                    out.writeLong(info.longData);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("dataType is illegal.");
                }
            }
        }
        out.close();
    }

    private static void writeString(DataOutputStream out, String value) throws IOException {
        byte[] bytes = value.getBytes();
        int i = 0;
        while (i < bytes.length) {
            out.writeByte(bytes[i]);
            ++i;
        }
    }

    private static void writeByteArray(DataOutputStream out, byte[] bytes) throws IOException {
        int i = 0;
        while (i < bytes.length) {
            out.writeByte(bytes[i]);
            ++i;
        }
    }

    public static List<byte[]> readBytesList(String fpath) throws IOException {
        int avail;
        BufferedInputStream fis = null;
        ArrayList<byte[]> readList = new ArrayList<byte[]>();
        File file = new File(fpath);
        fis = new BufferedInputStream(new FileInputStream(file));
        while ((avail = fis.available()) > 0) {
            byte[] bytes = new byte[avail];
            fis.read(bytes);
            readList.add(bytes);
        }
        if (fis != null) {
            fis.close();
        }
        return readList;
    }

    public static void saveBytes(String fpath, byte[] bytes, boolean append) throws IOException {
        BufferedOutputStream fis = null;
        File file = new File(fpath);
        fis = new BufferedOutputStream(new FileOutputStream(file, append));
        fis.write(bytes);
        if (fis != null) {
            fis.close();
        }
    }

    public static void saveBytesList(String fpath, List<byte[]> bytesList, boolean append) throws IOException {
        BufferedOutputStream fis = null;
        File file = new File(fpath);
        fis = new BufferedOutputStream(new FileOutputStream(file, append));
        Iterator<byte[]> itr = bytesList.iterator();
        while (itr.hasNext()) {
            fis.write(itr.next());
        }
        if (fis != null) {
            fis.close();
        }
    }

    public static void getFileList(String path, ArrayList<String> fileList) {
        File dir = new File(path);
        File[] files1 = dir.listFiles();
        int i = 0;
        while (i < files1.length) {
            File file = files1[i];
            if (files1[i].isFile()) {
                fileList.add(file.getAbsolutePath());
            } else if (files1[i].isDirectory()) {
                FileUtil.getFileList(file.getAbsolutePath(), fileList);
            }
            ++i;
        }
    }

    public static void getFileListByFilename(String path, ArrayList<String> fileList) {
        File dir = new File(path);
        File[] files1 = dir.listFiles();
        int i = 0;
        while (i < files1.length) {
            File file = files1[i];
            if (files1[i].isFile()) {
                fileList.add(file.getName());
            } else if (files1[i].isDirectory()) {
                FileUtil.getFileListByFilename(file.getAbsolutePath(), fileList);
            }
            ++i;
        }
    }

    public static List<ArrayList> readCsv(String fpath, String encode) throws IOException {
        return CsvUtil.readCsv(fpath, encode, ",", false);
    }

    public static void saveText(String path, String buff) throws IOException {
        FileOutputStream fos = null;
        OutputStreamWriter osr = null;
        BufferedWriter bw = null;
        fos = new FileOutputStream(path);
        osr = new OutputStreamWriter(fos);
        bw = new BufferedWriter(osr);
        bw.append(buff);
        bw.close();
        osr.close();
        fos.close();
    }

    public static void saveText(String path, String buff, boolean append, String encode) throws IOException {
        FileOutputStream fos = null;
        OutputStreamWriter osr = null;
        BufferedWriter bw = null;
        fos = new FileOutputStream(path, append);
        osr = new OutputStreamWriter((OutputStream)fos, encode);
        bw = new BufferedWriter(osr);
        bw.append(buff);
        if (bw != null) {
            bw.close();
        }
        if (osr != null) {
            osr.close();
        }
        if (fos != null) {
            fos.close();
        }
    }

    public static void saveTextArray(String path, ArrayList<String> lineList, boolean append, String encode) throws IOException {
        FileOutputStream fos = null;
        OutputStreamWriter osr = null;
        BufferedWriter bw = null;
        fos = new FileOutputStream(path, append);
        osr = new OutputStreamWriter((OutputStream)fos, encode);
        bw = new BufferedWriter(osr);
        for (String buff : lineList) {
            bw.append(buff);
        }
        if (bw != null) {
            bw.close();
        }
        if (osr != null) {
            osr.close();
        }
        if (fos != null) {
            fos.close();
        }
    }

    public static String loadText(String path) throws IOException {
        String buff = null;
        FileInputStream fis = new FileInputStream(path);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader in = new BufferedReader(isr);
        StringBuffer sbf = new StringBuffer("");
        while ((buff = in.readLine()) != null) {
            sbf.append(buff);
            sbf.append("\r\n");
        }
        buff = sbf.toString();
        return buff;
    }

    public static ArrayList<String> loadTextToArray(String path) throws IOException {
        String line = "";
        FileInputStream fis = new FileInputStream(path);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader in = new BufferedReader(isr);
        ArrayList<String> list = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            list.add(line);
        }
        in.close();
        isr.close();
        fis.close();
        return list;
    }

    public static void loadTextToArray(String path, List<String> list) throws IOException {
        String line = "";
        FileInputStream fis = new FileInputStream(path);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader in = new BufferedReader(isr);
        while ((line = in.readLine()) != null) {
            list.add(line);
        }
        in.close();
        isr.close();
        fis.close();
    }

    public static void loadTextToArray(String path, List<String> list, String outEncode) throws IOException {
        String line = "";
        FileInputStream fis = new FileInputStream(path);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader in = new BufferedReader(isr);
        while ((line = in.readLine()) != null) {
            String linewk = new String(line.getBytes(outEncode), outEncode);
            list.add(linewk);
        }
        in.close();
        isr.close();
        fis.close();
    }

    public static byte[] loadData(String path) {
        byte[] bytes = null;
        try {
            FileInputStream fis = new FileInputStream(path);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader in = new BufferedReader(isr);
            String buff = null;
            StringBuffer sbf = new StringBuffer("");
            while ((buff = in.readLine()) != null) {
                sbf.append(buff);
            }
            buff = sbf.toString();
            bytes = buff.getBytes();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public static String loadText(String path, String encode) throws IOException {
        String buff = null;
        FileInputStream fis = new FileInputStream(path);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, encode);
        BufferedReader in = new BufferedReader(isr);
        StringBuffer sbf = new StringBuffer("");
        while ((buff = in.readLine()) != null) {
            sbf.append(buff);
            sbf.append("\r\n");
        }
        buff = sbf.toString();
        return buff;
    }

    public static byte[] editByteArray(short bin) {
        ByteBuffer buf = ByteBuffer.allocate(2);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putShort(bin);
        return buf.array();
    }

    public static byte[] editByteArray(int bin) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(bin);
        return buf.array();
    }

    public static byte[] editByteArray(long bin) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(bin);
        return buf.array();
    }
}

