/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import common.util.LogCategory;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class LogTrace {
    public static final int FATAL_LVL = 1;
    public static final int ERRORLVL = 2;
    public static final int DEBUG_LVL = 3;
    public static final int WARN_LVL = 4;
    public static final int INFO_LVL = 5;
    private static ArrayList<LogCategory> categoryList = new ArrayList();
    private static int baseLevel = 3;
    private static String logpath = ".";
    private static String logFilename = "trace.log";
    private static String logFullpath = String.valueOf(logpath) + "\\" + logFilename;
    private static String encode = "UTF-8";
    private static String logmsg;
    private static boolean tmstampFlg;
    private static boolean moduleNameFlg;
    private static boolean consoleOutFlg;

    static {
        tmstampFlg = true;
        moduleNameFlg = true;
        consoleOutFlg = true;
    }

    public static void setLogpath(String _logpath) {
        logpath = _logpath;
        logFullpath = String.valueOf(logpath) + "\\" + logFilename;
    }

    public static void setLogFilename(String _logFilename) {
        logFilename = _logFilename;
        logFullpath = String.valueOf(logpath) + "\\" + logFilename;
    }

    public static void setEncode(String enc) {
        encode = enc;
    }

    public static void setLevel(int lvl) {
        baseLevel = lvl;
    }

    public static void setLogmsg(String msg) {
        logmsg = msg;
    }

    public static void setTmstampFlg(boolean _tmstampFlg) {
        tmstampFlg = _tmstampFlg;
    }

    public static void setModuleNameFlg(boolean _moduleNameFlg) {
        moduleNameFlg = _moduleNameFlg;
    }

    public static void setConsoleOutFlg(boolean _consoleOutFlg) {
        consoleOutFlg = _consoleOutFlg;
    }

    public static ArrayList<LogCategory> getCategoryList() {
        return categoryList;
    }

    public static void logout(int lvl) {
        LogTrace.logout(lvl, logmsg);
    }

    public static void logout(String category, int lvl) {
        for (LogCategory logCategory : categoryList) {
            if (!logCategory.getCategory().equals(category) || !logCategory.isActive()) continue;
            LogTrace.logout(lvl, logmsg);
        }
    }

    public static void logout(String category, int lvl, String buff) {
        for (LogCategory logCategory : categoryList) {
            if (!logCategory.getCategory().equals(category) || !logCategory.isActive()) continue;
            LogTrace.logout(lvl, buff);
        }
    }

    public static void logout(int lvl, String buff) {
        if (!LogTrace.isOutput(lvl)) {
            return;
        }
        String tmstamp = "";
        if (tmstampFlg) {
            Date curdate = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("[yyyy/MM/dd HH:mm:ss.SSS]");
            tmstamp = sdf.format(curdate);
        }
        String moduleInfo = "";
        if (moduleNameFlg) {
            Throwable t = new Throwable();
            StackTraceElement[] ste = t.getStackTrace();
            String className = "";
            String methodName = "";
            String lineNumber = "";
            int i = 1;
            while (i < 3) {
                className = ste[i].getClassName();
                methodName = ste[i].getMethodName();
                lineNumber = String.valueOf(ste[i].getLineNumber());
                if (!className.equals(LogTrace.class.getName())) break;
                ++i;
            }
            moduleInfo = "[" + className + "::" + methodName + ":" + lineNumber + "]";
        }
        if (consoleOutFlg) {
            System.out.println(String.valueOf(tmstamp) + moduleInfo + buff);
        }
        LogTrace.saveText(logFullpath, String.valueOf(tmstamp) + moduleInfo + buff);
    }

    public static void logout(int lvl, String buff, Exception ex) {
        if (!LogTrace.isOutput(lvl)) {
            return;
        }
        String tmstamp = "";
        if (tmstampFlg) {
            Date curdate = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("[yyyy/MM/dd HH:mm:ss.SSS]");
            tmstamp = sdf.format(curdate);
        }
        String moduleInfo = "";
        if (moduleNameFlg) {
            Throwable t = new Throwable();
            StackTraceElement[] ste = t.getStackTrace();
            String className = "";
            String methodName = "";
            int i = 1;
            while (i < 3) {
                className = ste[i].getClassName();
                methodName = ste[i].getMethodName();
                if (!className.equals(LogTrace.class.getName())) break;
                ++i;
            }
            moduleInfo = "[" + className + "::" + methodName + "]";
        }
        String exinfo = "";
        if (ex != null) {
            exinfo = LogTrace.editTraceInfo(ex);
            ex.printStackTrace();
        }
        LogTrace.saveText(logFullpath, String.valueOf(tmstamp) + moduleInfo + buff + exinfo);
    }

    public static String editTraceInfo(Exception ex) {
        StringBuilder sb = new StringBuilder();
        Exception th = ex;
        String detailMessage = th.getMessage();
        String exClassName = ex.getClass().getName();
        sb.append("\r\n\t").append(exClassName).append(" ").append(detailMessage);
        StackTraceElement[] elems = ex.getStackTrace();
        int idx = elems.length;
        int i = 0;
        while (i < elems.length) {
            sb.append("\r\n\t");
            sb.append(elems[i].getClassName());
            sb.append(".");
            sb.append(elems[i].getMethodName());
            sb.append("(");
            String filename = elems[i].getFileName();
            int lineNumber = elems[i].getLineNumber();
            if (filename == null) {
                sb.append("unknown Source");
            } else {
                sb.append(filename).append(":").append(lineNumber);
            }
            sb.append(")");
            ++i;
        }
        return sb.toString();
    }

    private static void saveText(String fullpath, String buff) {
        FileOutputStream fos = null;
        OutputStreamWriter osr = null;
        BufferedWriter bw = null;
        try {
            try {
                fos = new FileOutputStream(fullpath, true);
                osr = new OutputStreamWriter((OutputStream)fos, encode);
                bw = new BufferedWriter(osr);
                bw.append(buff);
                bw.append(System.getProperty("line.separator"));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                try {
                    osr.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                try {
                    fos.close();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException e5) {
                    e5.printStackTrace();
                }
                try {
                    osr.close();
                }
                catch (IOException e6) {
                    e6.printStackTrace();
                }
                try {
                    fos.close();
                }
                catch (IOException e7) {
                    e7.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                osr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isOutput(int lvl) {
        boolean rslt = true;
        if (lvl > baseLevel) {
            rslt = false;
        }
        return rslt;
    }
}

