/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import common.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public final class NetUtil {
    private static final int READ_BLOCK_SIZE = 1024;
    private static int readBlocksize = 1024;

    private NetUtil() {
    }

    public static void setReadBlocksize(int blockSize) {
        readBlocksize = blockSize;
    }

    public static int getReadBlocksize() {
        return readBlocksize;
    }

    public static void queryResponse(String inputUrl, String dstpath) {
        HttpURLConnection urlconn = null;
        BufferedReader br = null;
        try {
            try {
                String line;
                URL url = new URL(inputUrl);
                urlconn = (HttpURLConnection)url.openConnection();
                urlconn.connect();
                String encode = urlconn.getContentType();
                if (encode == null) {
                    encode = "Shift_JIS";
                } else {
                    int idx = encode.indexOf("charset");
                    if (idx == -1) {
                        encode = "Shift_JIS";
                    } else {
                        String[] tmp2;
                        String[] tmp1 = encode.split("=");
                        String rslt = tmp1[1];
                        if (rslt.indexOf("\"") >= 0) {
                            tmp2 = rslt.split("\"");
                            rslt = tmp2[1];
                        } else if (encode.indexOf("'") >= 0) {
                            tmp2 = rslt.split("'");
                            rslt = tmp2[1];
                        }
                        encode = rslt;
                    }
                }
                InputStreamReader ir = new InputStreamReader(urlconn.getInputStream(), encode);
                br = new BufferedReader(ir);
                StringBuilder sbf = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                    sbf.append(line.trim());
                    sbf.append("\r\n");
                }
                String rsppath = dstpath;
                FileUtil.saveText(rsppath, sbf.toString(), false, encode);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                if (urlconn != null) {
                    urlconn.disconnect();
                }
                return;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
                if (urlconn != null) {
                    urlconn.disconnect();
                }
                return;
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (urlconn != null) {
                urlconn.disconnect();
            }
        }
    }

    private static void download(String srcFilepath, String dstFilepath) throws IOException {
        int readLen;
        URL url = null;
        URLConnection conn = null;
        InputStream in = null;
        FileOutputStream out = null;
        url = new URL(srcFilepath);
        conn = url.openConnection();
        in = conn.getInputStream();
        File file = new File(dstFilepath);
        out = new FileOutputStream(file, false);
        byte[] bytes = new byte[readBlocksize];
        while ((readLen = in.read(bytes, 0, bytes.length)) > 0) {
            out.write(bytes, 0, readLen);
        }
        if (out != null) {
            out.close();
        }
        if (in != null) {
            in.close();
        }
    }
}

