/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import common.exception.OtherAppException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

public class PropertyUtil {
    private Hashtable<String, Properties> propMap = new Hashtable();

    public Hashtable<String, Properties> loadConfigByName(String confFilename) throws InvalidPropertiesFormatException, IOException {
        Properties propCfg = new Properties();
        InputStream stream = ClassLoader.getSystemResourceAsStream(confFilename);
        propCfg.loadFromXML(stream);
        stream.close();
        Enumeration<?> cfgnameList = propCfg.propertyNames();
        while (cfgnameList.hasMoreElements()) {
            String cfgkey = (String)cfgnameList.nextElement();
            String cfgname = propCfg.getProperty(cfgkey);
            Properties propwk = this.load(String.valueOf(cfgname) + ".xml");
            this.propMap.put(cfgname, propwk);
        }
        return this.propMap;
    }

    public Properties load(String confFilename) throws InvalidPropertiesFormatException, IOException {
        Properties prop = new Properties();
        InputStream stream = ClassLoader.getSystemResourceAsStream(confFilename);
        prop.loadFromXML(stream);
        stream.close();
        return prop;
    }

    public Properties load(String _confPath, String _confFilename) throws InvalidPropertiesFormatException, IOException {
        Properties prop = new Properties();
        FileInputStream stream = new FileInputStream(String.valueOf(_confPath) + File.separator + _confFilename);
        prop.loadFromXML(stream);
        ((InputStream)stream).close();
        return prop;
    }

    public String getProperty(String propName, String key) throws OtherAppException {
        Properties prop = this.propMap.get(propName);
        if (prop == null) {
            throw new OtherAppException("\u30d7\u30ed\u30d1\u30c6\u30a3\u30de\u30c3\u30d7\u306b\u3001[" + propName + "] \u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        return prop.getProperty(key);
    }
}

