/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;

public class PropertyUtilStatic {
    private static String confPath;
    private static String confFilename;
    static Properties prop;
    static Hashtable propMap;

    static {
        prop = null;
        propMap = new Hashtable();
    }

    public static void setConfPath(String fpath) {
        confPath = fpath;
    }

    public static String getConfPath() {
        return confPath;
    }

    public static void setConfFilename(String fname) {
        confFilename = fname;
    }

    public static void load() {
        prop = new Properties();
        try {
            FileInputStream stream = new FileInputStream(String.valueOf(confPath) + File.separator + confFilename);
            prop.loadFromXML(stream);
            ((InputStream)stream).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void load(String _confPath, String _confFilename) {
        prop = new Properties();
        try {
            FileInputStream stream = new FileInputStream(String.valueOf(_confPath) + File.separator + _confFilename);
            prop.loadFromXML(stream);
            ((InputStream)stream).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void load(String _confFilename) {
        prop = new Properties();
        try {
            InputStream stream = ClassLoader.getSystemResourceAsStream(_confFilename);
            prop.loadFromXML(stream);
            stream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void loadToMap(String _confPath, String _confFilename, String propName) {
        prop = new Properties();
        try {
            FileInputStream stream = new FileInputStream(String.valueOf(_confPath) + File.separator + _confFilename);
            prop.loadFromXML(stream);
            ((InputStream)stream).close();
            propMap.put(propName, prop);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void loadToMap(String _confFilename, String propName) {
        prop = new Properties();
        try {
            InputStream stream = ClassLoader.getSystemResourceAsStream(_confFilename);
            prop.loadFromXML(stream);
            stream.close();
            propMap.put(propName, prop);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String getProperty(String key) {
        return prop.getProperty(key);
    }
}

