/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import common.util.MyDate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class StringUtilExt {
    private static String[] gengou = new String[]{"\u6c5f\u6238", "\u660e\u6cbb", "\u5927\u6b63", "\u662d\u548c", "\u5e73\u6210", "\u672a\u6765"};
    private static MyDate[] gengouDttbl = new MyDate[]{new MyDate(1600, 1, 1), new MyDate(1868, 1, 25), new MyDate(1912, 7, 30), new MyDate(1926, 12, 15), new MyDate(1989, 1, 8), new MyDate(2050, 1, 1)};

    public static boolean isExistsTbl(String tbl, String txt) {
        if (txt.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < txt.length()) {
            String chr = txt.substring(i, i + 1);
            if (tbl.indexOf(chr) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isKatakana(String txt) {
        String tbl = "\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f3\u30f2";
        tbl = String.valueOf(tbl) + "\u30a1\u30a3\u30a5\u30a7\u30a9\u30e3\u30e5\u30e7\u30c3";
        tbl = String.valueOf(tbl) + "\u30ac\u30ae\u30b0\u30b2\u30b4\u30b6\u30b8\u30ba\u30bc\u30be\u30c0\u30c2\u30c5\u30c7\u30c9\u30d0\u30d3\u30d6\u30d9\u30dc\u30d1\u30d4\u30d7\u30da\u30dd\u30fc";
        return StringUtilExt.isExistsTbl(tbl, txt);
    }

    public static boolean isAscii(String txt) {
        boolean rslt = true;
        if (txt.length() != txt.getBytes().length) {
            rslt = false;
        }
        return rslt;
    }

    public static boolean isAlphaText(String txt) {
        return StringUtils.isAlpha((CharSequence)txt);
    }

    public static boolean isJavaIdentifier(String txt) {
        String tbl = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_$";
        if (txt.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < txt.length()) {
            String chr = txt.substring(i, i + 1);
            if (tbl.indexOf(chr) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String capitalize(String str) {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059\u3002");
        }
        return String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1, str.length());
    }

    public static String uncapitalize(String str) {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059\u3002");
        }
        return String.valueOf(str.substring(0, 1).toLowerCase()) + str.substring(1, str.length());
    }

    public static String cnvSystimeToString() {
        Date dt = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
        return sdf.format(dt);
    }

    public static String cnvSystimeToString(String format) {
        Date dt = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(dt);
    }

    public static String getListFileTime() {
        Date dt = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        return sdf.format(dt);
    }

    public static LinkedList splitString(int unitLength, String text) {
        if (unitLength <= 0) {
            throw new IllegalArgumentException("\"unitLength\" is illegal. \"unitLength\" is " + unitLength + ".");
        }
        if (text == null) {
            throw new IllegalArgumentException("\"text\" is null.");
        }
        if (text.length() <= 0) {
            throw new IllegalArgumentException("\"text\" is empty String.");
        }
        int div = text.length() / unitLength + (text.length() % unitLength == 0 ? 0 : 1);
        int pos = 0;
        LinkedList<String> dataList = new LinkedList<String>();
        int i = 0;
        while (i < div) {
            String s = "";
            s = text.length() < pos + unitLength ? text.substring(pos, text.length()) : text.substring(pos, pos + unitLength);
            dataList.add(s);
            pos += unitLength;
            ++i;
        }
        return dataList;
    }

    public static HashMap isExistsSameString(List<String> srcList) {
        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
        if (srcList.size() < 2) {
            return map;
        }
        ArrayList dstList = new ArrayList();
        dstList = (ArrayList)srcList;
        int i = 0;
        while (i < srcList.size() - 1) {
            String src = srcList.get(i);
            int j = i + 1;
            while (j < srcList.size()) {
                String dst = (String)dstList.get(j);
                if (src.equals(dst)) {
                    ArrayList<Integer> idxList = new ArrayList<Integer>();
                    ArrayList list = (ArrayList)map.get(src);
                    if (list == null) {
                        idxList.add(new Integer(i));
                        idxList.add(new Integer(j));
                        map.put(src, idxList);
                        break;
                    }
                    if (!list.contains(new Integer(i))) {
                        idxList.add(new Integer(i));
                    }
                    if (!list.contains(new Integer(j))) {
                        idxList.add(new Integer(j));
                    }
                    list.addAll(idxList);
                    map.put(src, list);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return map;
    }

    public static Date stringToDate(String date) {
        if (!StringUtilExt.isDateString(date)) {
            return null;
        }
        int year = new Integer(date.substring(0, 4));
        int month = new Integer(date.substring(4, 6));
        int day = new Integer(date.substring(6, 8));
        Calendar cal = Calendar.getInstance(new Locale("ja", "JAPAN"));
        cal.set(year, month - 1, day, 0, 0, 0);
        Date dt = cal.getTime();
        return dt;
    }

    public static boolean isDateString(String date) {
        int[] dayArray = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (date.length() < 8) {
            throw new IllegalArgumentException("\u65e5\u4ed8\u6587\u5b57\u5217\u9577\u304c\u4e0d\u6b63\u3002");
        }
        int year = new Integer(date.substring(0, 4));
        int month = new Integer(date.substring(4, 6));
        int day = new Integer(date.substring(6, 8));
        if (year < 1900) {
            throw new IllegalArgumentException("\u5e74\u306e\u5024\u304c\u4e0d\u6b63\uff08\u65e5\u4ed8\uff1d" + date + "\uff09\u3002");
        }
        if (month <= 0 || 12 < month) {
            throw new IllegalArgumentException("\u6708\u306e\u5024\u304c\u4e0d\u6b63\uff08\u65e5\u4ed8\uff1d" + date + "\uff09\u3002");
        }
        if (day <= 0) {
            throw new IllegalArgumentException("\u65e5\u306e\u5024\u304c\u4e0d\u6b63\uff08\u65e5\u4ed8\uff1d" + date + "\uff09\u3002");
        }
        if (month != 2 ? day > dayArray[month - 1] : (StringUtilExt.isUruYear(year) ? day > 29 : day > 28)) {
            throw new IllegalArgumentException("\u65e5\u306e\u5024\u304c\u4e0d\u6b63\uff08\u65e5\u4ed8\uff1d" + date + "\uff09\u3002");
        }
        return true;
    }

    public static boolean isUruYear(int year) {
        if (year < 1900) {
            return false;
        }
        if (year % 4 != 0) {
            return false;
        }
        boolean rtn = true;
        rtn = year % 400 != 0 ? (year % 100 == 0 ? false : year % 4 == 0) : true;
        return rtn;
    }

    public static String cnvDateYYMMDDtoYYYYMMDD(String srcDate) {
        if (srcDate.length() != 6) {
            throw new IllegalArgumentException("\u65e5\u4ed8\u6587\u5b57\u5217\u9577\u304c\u4e0d\u6b63\u3002");
        }
        String dstDate = "";
        int year = new Integer(srcDate.substring(0, 2));
        dstDate = String.valueOf(String.valueOf(year += 1900)) + srcDate.substring(2, srcDate.length());
        StringUtilExt.stringToDate(dstDate);
        return dstDate;
    }

    public static String hanNumToZen(String hantxt) {
        String hantbl = "0123456789";
        String zentbl = "\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19";
        StringBuffer sbf = new StringBuffer();
        int i = 0;
        while (i < hantxt.length()) {
            int idx = "0123456789".indexOf(hantxt.substring(i, i + 1));
            sbf.append("\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19".substring(idx, idx + 1));
            ++i;
        }
        return sbf.toString();
    }

    public static String zenNumToHan(String zentxt) {
        String hantbl = "0123456789";
        String zentbl = "\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19";
        StringBuffer sbf = new StringBuffer();
        int i = 0;
        while (i < zentxt.length()) {
            int idx = "\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19".indexOf(zentxt.substring(i, i + 1));
            sbf.append("0123456789".substring(idx, idx + 1));
            ++i;
        }
        return sbf.toString();
    }

    public static String trimzen(String txt) {
        String regex1 = "^\u3000*";
        String regex2 = "\u3000*$";
        return txt.replaceAll(regex1, "").replaceAll(regex2, "");
    }

    public static String trimHanZen(String orgStr) {
        char[] value = orgStr.toCharArray();
        int len = value.length;
        int st = 0;
        char[] val = value;
        while (st < len && (val[st] <= ' ' || val[st] == '\u3000')) {
            ++st;
        }
        while (st < len && (val[len - 1] <= ' ' || val[len - 1] == '\u3000')) {
            --len;
        }
        return st > 0 || len < value.length ? orgStr.substring(st, len) : orgStr;
    }

    public static boolean isWhiteSpace(String txt) {
        String template = " \t";
        return template.indexOf(txt) != -1;
    }

    public static HashMap<String, String> cnvYearSeirekiToWareki(Calendar srcCal) {
        MyDate srcDate = new MyDate(srcCal.get(1), srcCal.get(2), srcCal.get(5));
        return StringUtilExt.cnvYearSeirekiToWareki(srcDate);
    }

    public static HashMap<String, String> cnvYearSeirekiToWareki(MyDate srcDate) {
        HashMap<String, String> rsltMap = new HashMap<String, String>();
        int srcYear = srcDate.year;
        if (srcYear < StringUtilExt.gengouDttbl[0].year) {
            return rsltMap;
        }
        if (StringUtilExt.gengouDttbl[StringUtilExt.gengouDttbl.length - 1].year <= srcYear) {
            return rsltMap;
        }
        int genYear = 0;
        int i = 0;
        while (i < gengou.length - 1) {
            MyDate sd = gengouDttbl[i];
            MyDate ed = gengouDttbl[i + 1];
            if (StringUtilExt.isDateOnArea(sd, ed, srcDate)) {
                genYear = srcYear - sd.year + 1;
                rsltMap.put("TITLE", gengou[i]);
                rsltMap.put("YEAR", String.valueOf(genYear));
            }
            ++i;
        }
        return rsltMap;
    }

    public static boolean isDateOnArea(MyDate sd, MyDate ed, MyDate td) {
        if (sd.year == td.year && sd.month == td.month && sd.day == td.day) {
            return true;
        }
        return StringUtilExt.compareDate(sd, td) > 0 && StringUtilExt.compareDate(ed, td) < 0;
    }

    private static int compareDate(MyDate sd, MyDate td) {
        if (sd.year < td.year) {
            return 1;
        }
        if (sd.year > td.year) {
            return -1;
        }
        if (sd.month < td.month) {
            return 1;
        }
        if (sd.month > td.month) {
            return -1;
        }
        if (sd.day < td.day) {
            return 1;
        }
        if (sd.day > td.day) {
            return -1;
        }
        return 0;
    }

    public static boolean isInteger(String txt) {
        try {
            Integer.parseInt(txt);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public static boolean isDouble(String txt) {
        try {
            Double.parseDouble(txt);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }
}

