/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import common.util.AttributeParam;
import common.util.UpdateTagInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtil {
    private String xmlFilePath = null;
    private DocumentBuilderFactory factory = null;
    private DocumentBuilder builder = null;
    private Document document = null;
    private String encoding = "UTF-8";
    private XPath xpath;
    private Node rootNode = null;

    public Document getDocument() {
        return this.document;
    }

    public XmlUtil() throws ParserConfigurationException, SAXException, IOException {
        this.factory = DocumentBuilderFactory.newInstance();
        this.builder = this.factory.newDocumentBuilder();
        this.document = this.builder.newDocument();
    }

    public XmlUtil(String xmlFilePath) throws ParserConfigurationException, SAXException, IOException {
        this.xmlFilePath = xmlFilePath;
        this.factory = DocumentBuilderFactory.newInstance();
        this.builder = this.factory.newDocumentBuilder();
        this.document = this.builder.parse(new File(xmlFilePath));
    }

    public String getContent(String expression) {
        Node node = null;
        String content = "";
        try {
            node = (Node)this.xpath.evaluate(expression, this.document, XPathConstants.NODE);
            content = node.getTextContent();
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return content;
    }

    public ArrayList getContentList(String expression) {
        Object itemNode = null;
        Object childNode = null;
        Object nodeList = null;
        String content = "";
        ArrayList vallist = new ArrayList();
        return vallist;
    }

    public Element createRootElement(String elname) {
        Element elem = this.document.createElement(elname);
        this.document.appendChild(elem);
        return elem;
    }

    public Element appendChild(Element parent, String elname) {
        Element elem = this.document.createElement(elname);
        parent.appendChild(elem);
        return elem;
    }

    public boolean appendPropertyTagAttribute(String parentTagName, UpdateTagInfo tagInfo) {
        boolean rslt = false;
        if (this.isPropertyTagAttributeExist(parentTagName, tagInfo)) {
            return rslt;
        }
        Element configTag = this.document.getDocumentElement();
        NodeList parentTags = configTag.getElementsByTagName(parentTagName);
        Element parentTag = (Element)parentTags.item(0);
        Element elem = this.document.createElement("property");
        AttributeParam keyAttr = tagInfo.getKeyAttr();
        AttributeParam updateAttr = tagInfo.getUpdateAttr();
        elem.setAttribute(keyAttr.getName(), keyAttr.getValue());
        elem.setAttribute(updateAttr.getName(), updateAttr.getValue());
        parentTag.appendChild(elem);
        return true;
    }

    public boolean updateAttribute(String parentTagName, UpdateTagInfo tagInfo) {
        boolean rslt = false;
        Element configTag = this.document.getDocumentElement();
        NodeList parentTags = configTag.getElementsByTagName(parentTagName);
        Element parentTag = (Element)parentTags.item(0);
        NodeList propertyTags = parentTag.getElementsByTagName(tagInfo.getTagName());
        Element smtpServerPropertyTag = null;
        int i = 0;
        while (i < propertyTags.getLength()) {
            String propertyAttribute;
            Element propertyTag = (Element)propertyTags.item(i);
            String tagInfoKeyAttrValue = tagInfo.getKeyAttr().getValue();
            if (tagInfoKeyAttrValue.equals(propertyAttribute = propertyTag.getAttribute(tagInfo.getKeyAttr().getName()))) {
                smtpServerPropertyTag = propertyTag;
                break;
            }
            ++i;
        }
        if (smtpServerPropertyTag != null) {
            AttributeParam updateAttr = tagInfo.getUpdateAttr();
            smtpServerPropertyTag.setAttribute(updateAttr.getName(), updateAttr.getValue());
            rslt = true;
        }
        return rslt;
    }

    public boolean isPropertyTagAttributeExist(String parentTagName, UpdateTagInfo tagInfo) {
        boolean rslt = false;
        Element configTag = this.document.getDocumentElement();
        NodeList parentTags = configTag.getElementsByTagName(parentTagName);
        Element parentTag = (Element)parentTags.item(0);
        NodeList propertyTags = parentTag.getElementsByTagName(tagInfo.getTagName());
        int i = 0;
        while (i < propertyTags.getLength()) {
            String propertyAttribute;
            Element propertyTag = (Element)propertyTags.item(i);
            String tagInfoKeyAttrValue = tagInfo.getKeyAttr().getValue();
            if (tagInfoKeyAttrValue.equals(propertyAttribute = propertyTag.getAttribute(tagInfo.getKeyAttr().getName()))) {
                rslt = true;
                break;
            }
            ++i;
        }
        return rslt;
    }

    public void saveXml(String xmlpath, boolean indent) {
        if (this.document == null) {
            throw new IllegalArgumentException("document\u304c\u3001\u5b58\u5728\u3057\u306a\u3044");
        }
        if (xmlpath == null) {
            throw new IllegalArgumentException("");
        }
        TransformerFactory transFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transFactory.newTransformer();
            DOMSource source = new DOMSource(this.document);
            File newXML = new File(xmlpath);
            FileOutputStream os = new FileOutputStream(newXML);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public void saveXml(boolean indent) {
        this.saveXml(this.xmlFilePath, indent);
    }

    public String getElementValue(NodeList nodeList, String attrName, String value) {
        Element element = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            element = (Element)nodeList.item(i);
            if (element.getAttribute(attrName).equals(value)) break;
            ++i;
        }
        return element.getAttribute("value");
    }

    public LinkedList<Element> getElementList(NodeList nodeList, String attrName, String value) {
        LinkedList<Element> elementList = new LinkedList<Element>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element = (Element)nodeList.item(i);
            if (element.getAttribute(attrName).equals(value)) {
                elementList.add(element);
            }
            ++i;
        }
        return elementList;
    }

    public NodeList getNodeListByRoot(String tagname) {
        Document xmldoc = this.getDocument();
        Element root = xmldoc.getDocumentElement();
        return root.getElementsByTagName(tagname);
    }

    public void appendAttribute(Element elem, String attrName, String attrValue) {
        elem.setAttribute(attrName, attrValue);
    }

    public void appendAttributeList(Element elem, List<AttributeParam> attrInfoList) {
        for (AttributeParam info : attrInfoList) {
            elem.setAttribute(info.getName(), info.getValue());
        }
    }

    public String getAttributeByName(Element parent, String tagname, String attrname) {
        NodeList targetNodes = parent.getElementsByTagName(tagname);
        Element targetElem = (Element)targetNodes.item(0);
        return targetElem.getAttribute(attrname);
    }
}

