package common.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
* パスワードを不可逆暗号化する.
*/
public class PassDigest
{
	//------------------------------------------------------------------
	/**
	 * ユーザ名とパスワードでメッセージダイジェストを作成し文字列化して返す.
	 * @param userName ユーザ名.
	 * @param password パスワード.
	 * @return 生成したダイジェスト.
	 * @throws NoSuchAlgorithmException Java実行環境にSHA-1が実装されていない.
	 */
	public static String build(
			String userName,
			String password)
			throws NoSuchAlgorithmException
	{
		StringBuilder buff = new StringBuilder();
		if (password != null && !password.isEmpty()) {
			MessageDigest md = MessageDigest.getInstance("SHA-1");
			md.update(userName.getBytes());
			md.update(password.getBytes());
			byte[] digest = md.digest();

			for (byte d : digest) {
				buff.append((int) d & 0xFF);
			}
		}
		return buff.toString();
	}
}