package common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

import common.exception.OtherAppException;

/**
 * 定義ファイルは、クラスパス定義とする<br>
 * <pre>
 * 説明：定義データを取得する際に、プロパティ名称を指定しなければならないため、プロパティ名称は、
 * 　　プログラム定数として定義する必要がある。
 * </pre>
 *
 * @author yuki
 *
 */
public class PropertyInfo {

	private Properties prop = new Properties();

	/**
	 * 定義情報（単一）の取得<BR>
	 *
	 * <pre>
	 * 【概要】定義情報（単一）の取得。定義ファイルが格納されるフォルダがクラスパスとして定義されていること
	 * </pre>
	 *
	 * @param _confFilename
	 *            定義情報ファイル名 例：Sample.xml
	 * @throws IOException
	 * @throws InvalidPropertiesFormatException
	 */
	public Properties load(String confFilename) throws InvalidPropertiesFormatException,
			IOException {

		InputStream stream = ClassLoader.getSystemResourceAsStream(confFilename);

		prop.loadFromXML(stream);
		stream.close();

		return prop;
	}
	/**
	 * 複数プロパティ定義の定義データ取得
	 * <pre>
	 * 【概要】複数プロパティ定義の定義データ取得
	 * </pre>
	 * @param propName プロパティ名称
	 * @param key プロパティのキー
	 * @return 定義データ
	 * @throws OtherAppException
	 */
	public String getProperty(String key) throws OtherAppException {

		return prop.getProperty(key);

	}

}
