package common.util;

import java.io.FileOutputStream;
import java.sql.SQLException;
//import makevo.DBFieldInfo;
//import makevo.DBTableInfo;

/**
 *
 * @author hide
 *
 */
public class MakeDaoDef {
    static final private String cfgHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root>" ;
    static final private String cfgFooter = "</root>" ;

	static final private String indent = "    " ;
	static final private String indent2 = indent + indent  ;

	static final private String CRLF = System.getProperty("line.separator");

	/**
	 * テーブル定義部品編集
	 * @param tblname　テーブル名
	 * @param dbkind　データベース種別
	 * @return　編集結果
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	private String editHeader(MkDaoInfo info) {

       	//テーブル定義情報の編集
       	StringBuffer dbkindSbf = new StringBuffer("");

       	dbkindSbf.append(CRLF);
		dbkindSbf.append(indent);
       	dbkindSbf.append("<DbKind value=\"").append(String.valueOf(info.getDbkind())).append("\" />").append(CRLF);
		dbkindSbf.append(indent);
       	dbkindSbf.append("<DstPath value=\"").append(String.valueOf(info.getDstPath())).append("\" />").append(CRLF);
		dbkindSbf.append(indent);
       	dbkindSbf.append("<PkgnameVO value=\"").append(String.valueOf(info.getPkgnameVO())).append("\" />").append(CRLF);
		dbkindSbf.append(indent);
       	dbkindSbf.append("<PkgnameDAO value=\"").append(String.valueOf(info.getPkgnameDAO())).append("\" />").append(CRLF);
       	dbkindSbf.append(CRLF);

       	return dbkindSbf.toString();

	}
	/**
	 * 
	 * @param info
	 * @return
	 */
	private String editDaoInfo(MkDaoInfoItem info){
       	StringBuffer daoinfoSbf = new StringBuffer("");

       	daoinfoSbf.append(indent);
       	daoinfoSbf.append("<DaoInfo tblName=\"").append(String.valueOf(info.getTblname())).append("\"").append(CRLF);

       	daoinfoSbf.append(indent).append(indent);
       	daoinfoSbf.append("logicTblName=\"").append(String.valueOf(info.getLogicTablename())).append("\"").append(CRLF);

       	daoinfoSbf.append(indent).append(indent);
       	daoinfoSbf.append("voClass=\"").append(String.valueOf(info.getVoClassname())).append("\"").append(CRLF);

       	daoinfoSbf.append(indent).append(indent);
       	daoinfoSbf.append("daoClass=\"").append(String.valueOf(info.getDaoClassname())).append("\"").append(CRLF);

       	daoinfoSbf.append(indent).append(indent);
       	daoinfoSbf.append("logicVoClass=\"").append(String.valueOf(info.getLogicVoClassname())).append("\"").append(CRLF);

       	daoinfoSbf.append(indent).append(indent);
       	daoinfoSbf.append("logicDaoClass=\"").append(String.valueOf(info.getLogicDaoClassname())).append("\"").append(CRLF);

       	daoinfoSbf.append(indent).append(indent);
       	daoinfoSbf.append(">").append(CRLF);


       	daoinfoSbf.append(indent);
       	daoinfoSbf.append("</DaoInfo>").append(CRLF);

       	return daoinfoSbf.toString();
	}
	/**
	 * テーブル定義部品の作成
	 * @param tblname テーブル名
	 * @param dstpath　出力フォルダ
	 * @param dbkind　データベース種別
	 * @param updateItemList  UPDATE用の更新項目
	 */
	public void exec( MkDaoInfo mkDaoInfo){
		try {
			// 定義ファイル、またはDBのテーブルを参照して、Javaソース編集
		    StringBuilder sbf = new StringBuilder();

		    sbf.append(cfgHeader);

			sbf.append(editHeader(mkDaoInfo));


			//検索条件定義を追加
			for(MkDaoInfoItem mkDaoInfoItem : mkDaoInfo.getDaoInfoItemList()){
				sbf.append(editDaoInfo(mkDaoInfoItem));
			}

			sbf.append(cfgFooter);

			// Javaソースファイル出力
			FileOutputStream srcfile ;

			srcfile = new FileOutputStream( mkDaoInfo.getDstPath() + "/" + mkDaoInfo.getDstFile() );

			byte[] bytes = sbf.toString().getBytes();

			srcfile.write ( bytes, 0, bytes.length );

			System.out.println("出力ファイル："+  mkDaoInfo.getDstPath() + "/" + mkDaoInfo.getDstFile());
		}
		catch(java.io.FileNotFoundException e){
			e.printStackTrace();
		}
		catch(java.io.IOException e){
			e.printStackTrace();
		}
	}
	/**
	 *　データベースの（メタ）定義情報を取得し、テーブル定義ファイルにて使用する
	 *　テーブル定義部品の作成を行う
	 *
	 * テーブル定義部品の書式
	 * <Table name="WF001_BRANCH_TBL"
     *   <column name="Branch_no" type="number" precision="4"scale="0"  comment="店舗番号 店舗番号：ＳＧ情報として設定する。"  />
     *   <column name="Branch_name_id"  type="VARCHAR2" length="0"  comment="店舗名称 この店舗の名称。ＳＧ情報として設定する。"  />
     * </Table>
     *
	 * @param args[0] 	DBのテーブル名
	 * @param args[1] 	出力パス
	 * @param args[2] 	データベース種別  1=oracle, 2=PostgreSQL, 3=MySQL,4=DB2
	 *
	 * 引数サンプル
	 *  WF001_BRANCH_TBL D:\tmp 1
	 */
//	public static void main(String[] args) {
//		// TODO 自動生成されたメソッド・スタブ
//		MkTableDef app = new MkTableDef();
//
//    	if (args.length < 3){
//			MkClassUtil.errorMsg(args_error);
//    		System.exit(1);
//    	}
//    	/** DBテーブル名設定 */
//    	String tblname = args[0];
//    	String dstpath = args[1];
//    	int dbkind = (new Integer(args[2])).intValue() ;
//    	if ((dbkind < 1) || (dbkind > DbUtilConst.DB_RESOURCE_NAME.length)){
//			MkClassUtil.errorMsg(args_error);
//    		System.exit(1);
//    	}
//       	String resourceParamsName = MkClassConst.RESOURCE_PARAMS_NAME[dbkind-1];
//    	MkClassCommon mc = new MkClassCommon(dbkind, "xml/dbconfig.xml",resourceParamsName);
//    	mc.setDbkind(dbkind);
//
//    	//自分自身に、mc設定
//    	app.setMc(mc);
//
//   		app.exec(tblname, dstpath, dbkind);
//
//	}
	static private String args_error 	=
		"usage : java MkTableDef  ＤＢテーブル名 出力パス データベース種別\n" +
   		"　データベース種別：1=oracle, 2=PostgreSQL, 3=MySQL, 4=DB2";

}
