/**
 *
 */
package common.util;

import java.text.ParseException;
import java.util.Calendar;

import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;



/**
 * @author zt8h-
 *
 */
class StringUtilExtTest {

    /**
     * @throws java.lang.Exception
     */
    @BeforeEach
    void setUp() throws Exception {
    }

    /**
     * @throws java.lang.Exception
     */
    @AfterEach
    void tearDown() throws Exception {
    }

    @Test
    void testStringUtilExt() {
        Calendar cal = Calendar.getInstance();
        cal.set(1868 ,9, 12);
        
        String wareki = StringUtilExt.cnvSeirekiToWareki(cal.getTime());
        Assert.assertEquals("明治01年10月12日",wareki);
    }
    @Test
    void testStringUtilExt2() {
        Calendar cal = Calendar.getInstance();
        cal.set(1867, 9, 12);

        try {
            StringUtilExt.cnvSeirekiToWareki(cal.getTime());
        }
        catch(IllegalArgumentException e) {
            Assert.assertEquals("日付は明治以降を指定してください。",e.getMessage());
        }
    }
    @Test
    void testStringUtilExt3() {
        String param1 = "令和04年10月12日";
        String seireki="";
        try {
            seireki = StringUtilExt.cnvWarekiToSeireki(param1);
        } catch (ParseException e) {
            // TODO 自動生成された catch ブロック
            e.printStackTrace();
        }

        Assert.assertEquals("2022年10月12日",seireki);

    }
    @Test
    void testTrimHanZen_ok() {
        String param1 = "　 令和04年10月12日 ";
        
        String rslt = StringUtilExt.trimHanZen(param1);

        Assert.assertEquals("令和04年10月12日",rslt);

    }
    @Test
    void testTrimHanZen_ng() {
        String param1 = "";
        
        try {
            StringUtilExt.trimHanZen(param1);
        }
        catch(IllegalArgumentException e) {
            Assert.assertEquals("パラメータがnullまたは空文字です。",e.getMessage());
        }

    }
    @Test
    void testIsKatakana_ok() {
        String param1 = "ｧｨｩｪｫｶﾞｷﾞｸﾞｹﾞｺﾞﾊﾟﾋﾟﾌﾟﾍﾟﾎﾟ";
        
        boolean rslt = StringUtilExt.isKatakana(param1);
        Assert.assertTrue(rslt);
    }
    @Test
    void testIsKatakana_ng() {
        String param1 = "カaキクケコｧｨｩｪｫパピプペポ";
        
        boolean rslt = StringUtilExt.isKatakana(param1);
        Assert.assertFalse(rslt);
    }
    @Test
    void testIsKatakana_ng2() {
        String param1 = "";
        
        try {
            StringUtilExt.isKatakana(param1);
        }
        catch(IllegalArgumentException e) {
            Assert.assertEquals("パラメータがnullまたは空文字です。",e.getMessage());
        }
    }

}
