package common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import common.exception.AppException;

class XmlUtilTest {

    @BeforeEach
    void setUp() throws Exception {
    }

    @Test
    public void estGetElementValue() {
        XmlUtil xmlUtil = null;
        List<String> importTxtList = new ArrayList<String>();
        List<String> setParamList = new ArrayList<String>();
        List<TestConfig> testConfigList = new ArrayList<TestConfig>();
        List<Param> paramList = new ArrayList<Param>();
        TestConfig testConfig = null;

        try {
            xmlUtil = new XmlUtil("xml/testCodeConfig.xml");
        } catch (ParserConfigurationException e) {
            // TODO 自動生成された catch ブロック
            e.printStackTrace();
        } catch (SAXException e) {
            // TODO 自動生成された catch ブロック
            e.printStackTrace();
        } catch (IOException e) {
            // TODO 自動生成された catch ブロック
            e.printStackTrace();
        }
        Element root = xmlUtil.getDocument().getDocumentElement();
        NodeList testCodeList = root.getElementsByTagName("TestCode");

        for (int i = 0; i < testCodeList.getLength(); i++) {
            Element element = (Element) testCodeList.item(i);

            NodeList importNodeTxtList = element.getElementsByTagName("importTxt");
            Element elemImport = (Element) importNodeTxtList.item(i);
            // importTxt取得
            String importTxt = elemImport.getTextContent();
            importTxtList.add(importTxt);

//          public TestConfig(String _methodName, boolean _isStatic, String _returnTypeName,String _testType, 
//          String _setparam, Param[] _params, String _expected) {
            try {

                NodeList methodNodeList = element.getElementsByTagName("method");
                for (int j = 0; j < methodNodeList.getLength(); j++) {
                    Element elemMethod = (Element) methodNodeList.item(j);
                    // メソッド定義情報設定
                    testConfig = setTestConfig(elemMethod);
                    NodeList setParamNodeList = elemMethod.getElementsByTagName("setparam");
                    for (int k = 0; j < setParamNodeList.getLength(); k++) {
                        Element elemSetParam = (Element) setParamNodeList.item(k);

                        String setParam = elemSetParam.getTextContent();
                        setParamList.add(setParam);
                    }
                    NodeList paramNodeList = elemMethod.getElementsByTagName("param");
                    for (int k = 0; j < paramNodeList.getLength(); k++) {
                        Param param = new Param();
                        Element elemParam = (Element) paramNodeList.item(k);
                        String type = elemParam.getAttribute("type");
                        String value = elemParam.getAttribute("value");
                        if ((type == null) || (type.length() == 0)) {
                            throw new AppException("メソッド定義情報(タグ：param、属性：type)が不正です。");
                        }
                        if ((value == null) || (value.length() == 0)) {
                            throw new AppException("メソッド定義情報(タグ：param、属性：value)が不正です。");
                        }
                        param.setTypeName(type);
                        param.setValue(value);
                        
                        paramList.add(param);
                    }
                    testConfigList.add(testConfig);
                }
            } catch (AppException e) {
                // TODO 自動生成された catch ブロック
                e.printStackTrace();
            }
        }
    }

    private TestConfig setTestConfig(Element elemMethod) throws AppException {

        TestConfig testConfig = new TestConfig();
        String methodName = elemMethod.getAttribute("methodName");
        if ((methodName == null) || (methodName.length() == 0)) {
            throw new AppException("メソッド定義情報(タグ：method、属性：methodName)が不正です。");
        }
        testConfig.setMethodName(methodName);

        String isStatic = elemMethod.getAttribute("isStatic");
        if ((isStatic == null) || (isStatic.length() == 0)) {
            throw new AppException("メソッド定義情報(タグ：method、属性：isStatic)が不正です。");
        }
        if (isStatic.equals("true")) {
            testConfig.setStatic(true);
        } else if (isStatic.equals("false")) {
            testConfig.setStatic(false);
       }
        
        String returnTypeName = elemMethod.getAttribute("returnTypeName");
        if ((returnTypeName== null) || (returnTypeName.length() == 0)) {
            throw new AppException("メソッド定義情報(タグ：method、属性：returnTypeName)が不正です。");
        }
        testConfig.setReturnTypeName(returnTypeName);

        String testType = elemMethod.getAttribute("testType");
        if ((testType== null) || (testType.length() == 0)) {
            throw new AppException("メソッド定義情報(タグ：method、属性：testType)が不正です。");
        }
        testConfig.setTestType(testType);

        String expected = elemMethod.getAttribute("expected");
        if ((expected== null) || (expected.length() == 0)) {
            throw new AppException("メソッド定義情報(タグ：method、属性：expected)が不正です。");
        }
        testConfig.setExpected(expected);

        return testConfig;
    }

}
